//collision handling (returns "R", "L", "U", "D", "N" if collision to right, left, up, down & no collision respectively
function collisioncheck() {
    function collisionzoneschecker(x,y) {
        for (let i=0; i<currcollisionzones.length; i++){
            if (currcollisionzones[i][0] === x && currcollisionzones[i][1] === y) return true;
        }
        return false;
    }
    let x = playerPOSdata["xcoord"]; let y = playerPOSdata["ycoord"];
    let collisionresultlist = [];
    if (x+1 >= currmap[0].length
        || collisionzoneschecker(x+1,y)
        || collision_tiletypes.includes(currmap[y][x + 1])) collisionresultlist.push("R");
    if (x-1 < 0
        || collisionzoneschecker(x-1,y)
        || collision_tiletypes.includes(currmap[y][x - 1])) collisionresultlist.push("L");
    if (y-1 < 0
        || collisionzoneschecker(x,y-1)
        || collision_tiletypes.includes(currmap[y - 1][x])) collisionresultlist.push("U");
    if (y+1 >= currmap.length
        || collisionzoneschecker(x,y+1)
        || collision_tiletypes.includes(currmap[y + 1][x])) collisionresultlist.push("D");
    if (collisionresultlist.length === 0) collisionresultlist.push("N");
    return collisionresultlist;
}

//loadingzone checker (returns which loading zone is in direction of right(R), left(L), up(U) down(D) & on tile itself(O). returns -1 when no t found
function loadingzonecheck(direction) {
    let x = playerPOSdata["xcoord"]; let y = playerPOSdata["ycoord"];
    for (let h=0; h<currloadingzones[0].length; h++) {
        if (direction === "R"
            && currloadingzones[0][h][0][0] === x+1
            && currloadingzones[0][h][0][1] === y
            && currloadingzones[0][h][1] === "R"){
            return h;
        }
        if (direction === "L"
            && currloadingzones[0][h][0][0] === x-1
            && currloadingzones[0][h][0][1] === y
            && currloadingzones[0][h][1] === "L") {
            return h;
        }
        if (direction === "U"
            && currloadingzones[0][h][0][0] === x
            && currloadingzones[0][h][0][1] === y-1
            && currloadingzones[0][h][1] === "U") {
            return h;
        }
        if (direction === "D"
            && currloadingzones[0][h][0][0] === x
            && currloadingzones[0][h][0][1] === y+1
            && currloadingzones[0][h][1] === "D") {
            return h;
        }
    }
    return -1;
}

//loading zone handler
function loadingzonehandle(keyevent) {
    function setspawnbehaviour(loadingzonenum) {
        if (currloadingzones[1][loadingzonenum][2] === "R"){
            playerSdata["sprite"] = 0;
            playerSdata["xmoving"] = 9;
        }
        if (currloadingzones[1][loadingzonenum][2] === "L"){
            playerSdata["sprite"] = 1;
            playerSdata["xmoving"] = -9;
        }
        if (currloadingzones[1][loadingzonenum][2] === "U"){
            playerSdata["sprite"] = 2;
            playerSdata["ymoving"] = -9;
        }
        if (currloadingzones[1][loadingzonenum][2] === "D"){
            playerSdata["sprite"] = 3;
            playerSdata["ymoving"] = 9;
        }
    }
    if (keyevent.key === "ArrowRight"
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && loadingzonecheck("R") !== -1) {
        let loadingzonenum = loadingzonecheck("R");
        mapnum = currloadingzones[1][loadingzonenum][0];
        currbuildingzones = buildingingzones[mapnum];
        playerPOSdata["xcoord"] = currloadingzones[1][loadingzonenum][1][0];
        playerPOSdata["ycoord"] = currloadingzones[1][loadingzonenum][1][1];
        setspawnbehaviour(loadingzonenum);
    }
    if (keyevent.key === "ArrowLeft"
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && loadingzonecheck("L") !== -1) {
        let loadingzonenum = loadingzonecheck("L");
        mapnum = currloadingzones[1][loadingzonenum][0];
        setspawnbehaviour(loadingzonenum);
        currbuildingzones = buildingingzones[mapnum];
        playerPOSdata["xcoord"] = currloadingzones[1][loadingzonenum][1][0];
        playerPOSdata["ycoord"] = currloadingzones[1][loadingzonenum][1][1];
    }
    if (keyevent.key === "ArrowUp"
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && loadingzonecheck("U") !== -1) {
        let loadingzonenum = loadingzonecheck("U");
        mapnum = currloadingzones[1][loadingzonenum][0];
        setspawnbehaviour(loadingzonenum);
        currbuildingzones = buildingingzones[mapnum];
        playerPOSdata["xcoord"] = currloadingzones[1][loadingzonenum][1][0];
        playerPOSdata["ycoord"] = currloadingzones[1][loadingzonenum][1][1];
    }
    if (keyevent.key === "ArrowDown"
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && loadingzonecheck("D") !== -1) {
        let loadingzonenum = loadingzonecheck("D");
        mapnum = currloadingzones[1][loadingzonenum][0];
        setspawnbehaviour(loadingzonenum);
        currbuildingzones = buildingingzones[mapnum];
        playerPOSdata["xcoord"] = currloadingzones[1][loadingzonenum][1][0];
        playerPOSdata["ycoord"] = currloadingzones[1][loadingzonenum][1][1];
    }
    //switch tilemap
    currmap = maps[mapnum];
    //refresh map supplements
    currloadingzones = loadingzones[mapnum];
    currcollisionzones = collisionzones[mapnum];
    currbordertiles = bordertiles[mapnum];
}

//keyboard movement controls
function keyboard_to_movement(keyevent) {
    if (keyevent.key === "ArrowRight"
        && playerPOSdata["xcoord"] <= currmap[0].length
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && !collisioncheck().includes("R")) {
        playerPOSdata["xcoord"] += 1;
        playerSdata["xmoving"] = 9;
        playerSdata["sprite"] = 0;
        playerSdata["lastmoved"] = Date.now();
    }
    if (keyevent.key === "ArrowLeft"
        && playerPOSdata["xcoord"] > 0
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && !collisioncheck().includes("L")) {
        playerPOSdata["xcoord"] -= 1;
        playerSdata["xmoving"] = -9;
        playerSdata["sprite"] = 1;
        playerSdata["lastmoved"] = Date.now();
    }
    if (keyevent.key === "ArrowUp"
        && playerPOSdata["ycoord"] > 0
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && !collisioncheck().includes("U")) {
        playerPOSdata["ycoord"] -= 1;
        playerSdata["ymoving"] = -9;
        playerSdata["sprite"] = 2;
        playerSdata["lastmoved"] = Date.now();
    }
    if (keyevent.key === "ArrowDown"
        && playerPOSdata["ycoord"] <= currmap.length
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && !(collisioncheck().includes("D"))) {
        playerPOSdata["ycoord"] += 1;
        playerSdata["ymoving"] = 9;
        playerSdata["sprite"] = 3;
        playerSdata["lastmoved"] = Date.now();
    }
}