//canvas setup

const gamescreen = document.querySelector('.gamescreen');
const gs_ctx = gamescreen.getContext('2d');
const height = gamescreen.height = window.innerHeight*0.9;
/*const width = */gamescreen.width = height;
let tileD = height*(1/12);
let centrecord = height*0.5-tileD*0.5

let currmap = maps[mapnum]; //set default map to testmap1
let currloadingzones = loadingzones[mapnum];
let currbuildingzones = buildingingzones[mapnum];
let currcollisionzones = collisionzones[mapnum];
let currbordertiles = bordertiles[mapnum];

//drawing
draw();

function drawsprite(){
    gs_ctx.drawImage(playerS, playerSdata["sprite"]*500, 0, 500, 500, centrecord, centrecord, tileD*0.9, tileD*0.9);
}

function drawmap() {
    for(let y=-1.5; y<=12.5; y+=1) {
        for (let x=-1.5; x<=12.5; x+=1) {
            let blockXY = [tileD*x+tileD*(playerSdata["xmoving"]/10), tileD*y+tileD*(playerSdata["ymoving"]/10)];
            let tileXY = [x-5.5+playerPOSdata["xcoord"], y-5.5+playerPOSdata["ycoord"]];
            if (tileXY[0] < 0 || tileXY[0] >= currmap[0].length || tileXY[1] < 0 || tileXY[1] >= currmap.length) {
                if (currbordertiles >= 0) {
                    gs_ctx.drawImage(tileset[1][currbordertiles], 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                }
                else{
                    gs_ctx.drawImage(tileset[0][tileset[0].length+currbordertiles], 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                }
            }
            else {
                if (currmap[tileXY[1]][tileXY[0]] >= 0) {
                    gs_ctx.drawImage(tileset[1][currmap[tileXY[1]][tileXY[0]]], 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                }
                else{
                    gs_ctx.drawImage(tileset[0][tileset[0].length+currmap[tileXY[1]][tileXY[0]]], 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                }
            }
        }
    }
}

function drawbuildings() {
    for (let i = 0; i < currbuildingzones.length; i++) {
        let BT = buildingtypes[currbuildingzones[i][1]]; //building type
        let buildingXY = [(currbuildingzones[i][0][0]-playerPOSdata["xcoord"]+5.5)*tileD+tileD*(playerSdata["xmoving"]/10),
            (currbuildingzones[i][0][1]-playerPOSdata["ycoord"]+5.5)*tileD+tileD*(playerSdata["ymoving"]/10)];
        gs_ctx.drawImage(BT[0], 0, 0, BT[1][0], BT[1][1],
            buildingXY[0]+BT[1][4]*tileD, buildingXY[1]+BT[1][5]*tileD, tileD*BT[1][2], tileD*BT[1][3]);
    }
}

function draw() {
    drawmap();
    drawsprite();
    drawbuildings();
    if (playerSdata["xmoving"] > 0) playerSdata["xmoving"] -= 1;
    if (playerSdata["xmoving"] < 0) playerSdata["xmoving"] += 1;
    if (playerSdata["ymoving"] > 0) playerSdata["ymoving"] -= 1;
    if (playerSdata["ymoving"] < 0) playerSdata["ymoving"] += 1;
    window.requestAnimationFrame(draw);
    //show coordinates
    document.getElementById("bottomtextbox").innerText = JSON.stringify(playerSdata) + " | "
        + JSON.stringify(playerPOSdata) + " | "+ /*collisioncheck().toString() + */"\n"
        +[6.5-6.5+playerPOSdata["xcoord"], 6.5-6.5+playerPOSdata["ycoord"]].toString()
}