//canvas setup

const gamescreen = document.querySelector('.gamescreen');
const gs_ctx = gamescreen.getContext('2d');
const height = gamescreen.height = window.innerHeight*0.9;
/*const width = */gamescreen.width = height;
let tileD = height*(1/12);
let centrecord = height*0.5-tileD*0.5

let currmap = maps[0]; //set default map to testmap1
let currloadingzones = loadingzones[0];

//load in images
//sprites
//playersprite setup
let playerS = new Image();
playerS.src = './assets/orange_rectangle_person.png';
let playerSdata = {"sprite":0, "lastmoved":Date.now(), "xmoving":0, "ymoving":0};
let playerPOSdata = {"xcoord":6, "ycoord":6}

//tiles
//notfoundtile
let notfoundT = new Image();
notfoundT.src = './assets/notfoundtile.png'
//basicgrass(0)
let basicgrassT = new Image();
basicgrassT.src = './assets/0_basicgrass.png'
//dirtpath(1)
let dirtpathT = new Image();
dirtpathT.src = './assets/1_dirtpath.png';
//calmwater(2)
let calmwaterT = new Image();
calmwaterT.src = './assets/2_calmwater.png';
//???(4)
//flowers(5)
let flowersT = new Image();
flowersT.src = './assets/5_flowers.png';

//drawing
draw();

function drawsprite(){
    gs_ctx.drawImage(playerS, playerSdata["sprite"]*500, 0, 500, 500, centrecord, centrecord, tileD*0.9, tileD*0.9);
}

function drawmap() {
    for(let y = 0; y < currmap.length; ++y) {
        for (let x = 0; x < currmap[0].length; ++x) {
            let blockXY = [x*tileD-(playerPOSdata["xcoord"]-6)*tileD+tileD*(playerSdata["xmoving"]/10)-tileD*0.5,
                           y*tileD-(playerPOSdata["ycoord"]-6)*tileD+tileD*(playerSdata["ymoving"]/10)-tileD*0.5]
            switch (currmap[y][x]) {
                case 0:
                    gs_ctx.drawImage(basicgrassT, 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                    break;
                case 1:
                    gs_ctx.drawImage(dirtpathT, 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                    break;
                case 2:
                    gs_ctx.drawImage(calmwaterT, 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                    break;
                case 5:
                    gs_ctx.drawImage(flowersT, 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                    break;
                default:
                    gs_ctx.drawImage(notfoundT, 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                    break;
            }
        }
    }
    if (playerSdata["xmoving"] > 0) playerSdata["xmoving"] -= 1;
    if (playerSdata["xmoving"] < 0) playerSdata["xmoving"] += 1;
    if (playerSdata["ymoving"] > 0) playerSdata["ymoving"] -= 1;
    if (playerSdata["ymoving"] < 0) playerSdata["ymoving"] += 1;
}

function draw() {
    drawmap();
    drawsprite();
    window.requestAnimationFrame(draw);
    //show coordinates
    document.getElementById("bottomtextbox").innerText = JSON.stringify(playerSdata) + "\n"
                                                                  + JSON.stringify(playerPOSdata) + "\n"
                                                                  + collisioncheck().toString() + "\n" +
                                                                  + loadingzonecheck("R") + ", "
                                                                  + loadingzonecheck("L") + ", "
                                                                  + loadingzonecheck("U") + ", "
                                                                  + loadingzonecheck("D");
}

//collision handling (returns "R", "L", "U", "D", "N" if collision to right, left, up, down & no collision respectively
function collisioncheck() {
    let x = playerPOSdata["xcoord"]; let y = playerPOSdata["ycoord"];
    let collisionresultlist = [];
    if (collision_tiles.includes(currmap[y][x + 1])) collisionresultlist.push("R");
    if (collision_tiles.includes(currmap[y][x - 1])) collisionresultlist.push("L");
    if (collision_tiles.includes(currmap[y - 1][x])) collisionresultlist.push("U");
    if (collision_tiles.includes(currmap[y + 1][x])) collisionresultlist.push("D");
    if (collisionresultlist.length === 0) collisionresultlist.push("N");
    return collisionresultlist;
}

//loadingzone handling (returns which loading zone is in direction of right(R), left(L), up(U) & down(D). returns -1 when no t found
function loadingzonecheck(direction) {
    let x = playerPOSdata["xcoord"]; let y = playerPOSdata["ycoord"];
    for (let h=0; h<currloadingzones[0].length; h++) {
        if (direction === "R"
            &&currloadingzones[0][h][0] === x+1
            && currloadingzones[0][h][1] === y){
            return h;
        }
        if (direction === "L"
            && currloadingzones[0][h][0] === x-1
            && currloadingzones[0][h][1] === y) {
            return h;
        }
        if (direction === "U"
            && currloadingzones[0][h][0] === x
            && currloadingzones[0][h][1] === y-1) {
            return h;
        }
        if (direction === "D"
            && currloadingzones[0][h][0] === x
            && currloadingzones[0][h][1] === y+1) {
            return h;
        }
    }
    return -1;
}

//keyboard stuff
function keyboardstuff(keyevent) {
    loadingzonehandle(keyevent);
    keyboard_to_movement(keyevent);
}

//loading zone handler
function loadingzonehandle(keyevent) {

    if (keyevent.key === "ArrowRight"
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && loadingzonecheck("R") !== -1) {
        let loadingzonenum = loadingzonecheck("R");
        let newmapnum = currloadingzones[1][loadingzonenum][0];
        playerSdata["sprite"] = 0;
        currmap = maps[newmapnum];
        playerPOSdata["xcoord"] = currloadingzones[1][loadingzonenum][1];
        playerPOSdata["ycoord"] = currloadingzones[1][loadingzonenum][2];
        playerSdata["xmoving"] = 19;
        currloadingzones = loadingzones[newmapnum];
    }
    if (keyevent.key === "ArrowLeft"
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && loadingzonecheck("L") !== -1) {
        let loadingzonenum = loadingzonecheck("L");
        let newmapnum = currloadingzones[1][loadingzonenum][0];
        playerSdata["sprite"] = 1;
        currmap = maps[newmapnum];
        playerPOSdata["xcoord"] = currloadingzones[1][loadingzonenum][1];
        playerPOSdata["ycoord"] = currloadingzones[1][loadingzonenum][2];
        playerSdata["xmoving"] = -19;
        currloadingzones = loadingzones[newmapnum];
    }
    if (keyevent.key === "ArrowUp"
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && loadingzonecheck("U") !== -1) {
        let loadingzonenum = loadingzonecheck("U");
        let newmapnum = currloadingzones[1][loadingzonenum][0];
        playerSdata["sprite"] = 2;
        currmap = maps[newmapnum];
        playerPOSdata["xcoord"] = currloadingzones[1][loadingzonenum][1];
        playerPOSdata["ycoord"] = currloadingzones[1][loadingzonenum][2];
        playerSdata["ymoving"] = -19;
        currloadingzones = loadingzones[newmapnum];
    }
    if (keyevent.key === "ArrowDown"
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && loadingzonecheck("D") !== -1) {
        let loadingzonenum = loadingzonecheck("D");
        let newmapnum = currloadingzones[1][loadingzonenum][0];
        playerSdata["sprite"] = 3;
        currmap = maps[newmapnum];
        playerPOSdata["xcoord"] = currloadingzones[1][loadingzonenum][1];
        playerPOSdata["ycoord"] = currloadingzones[1][loadingzonenum][2];
        playerSdata["ymoving"] = 19;
        currloadingzones = loadingzones[newmapnum];
    }
}

//keyboard movement controls
function keyboard_to_movement(keyevent) {
    if (keyevent.key === "ArrowRight"
        && playerPOSdata["xcoord"] < currmap[0].length - 7
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && !collisioncheck().includes("R")) {
        playerPOSdata["xcoord"] += 1;
        playerSdata["xmoving"] = 9;
        playerSdata["sprite"] = 0;
        playerSdata["lastmoved"] = Date.now();
    }
    if (keyevent.key === "ArrowLeft"
        && playerPOSdata["xcoord"] > 6
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && !collisioncheck().includes("L")) {
        playerPOSdata["xcoord"] -= 1;
        playerSdata["xmoving"] = -9;
        playerSdata["sprite"] = 1;
        playerSdata["lastmoved"] = Date.now();
    }
    if (keyevent.key === "ArrowUp"
        && playerPOSdata["ycoord"] > 6
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && !collisioncheck().includes("U")) {
        playerPOSdata["ycoord"] -= 1;
        playerSdata["ymoving"] = -9;
        playerSdata["sprite"] = 2;
        playerSdata["lastmoved"] = Date.now();
    }
    if (keyevent.key === "ArrowDown"
        && playerPOSdata["ycoord"] < currmap.length - 7
        && playerSdata["xmoving"] === 0
        && playerSdata["ymoving"] === 0
        && !(collisioncheck().includes("D"))) {
        playerPOSdata["ycoord"] += 1;
        playerSdata["ymoving"] = 9;
        playerSdata["sprite"] = 3;
        playerSdata["lastmoved"] = Date.now();
    }
}

window.addEventListener("keydown", function(key){keyboardstuff(key)})