//canvas setup
// noinspection JSSuspiciousNameCombination

const gamescreen = document.querySelector('.gamescreen');
const gs_ctx = gamescreen.getContext('2d');
const height = gamescreen.height = window.innerHeight*0.9;
/*const width = */gamescreen.width = height;
let tileD = height*(1/12);

//load in images
//sprites
//playersprite setup
let playerS = new Image();
playerS.src = './assets/orange_rectangle_person.png';
playerSdata = [height*0.5,height*0.5,0];

//tiles
//dirtpath(0)
let dirtpathT = new Image();
dirtpathT.src = './assets/0_dirtpath.png';
//calmwater(1)
let calmwaterT = new Image();
calmwaterT.src = './assets/1_calmwater.png';

//drawing
draw();
function draw() {
    for(let y = 0; y < 12; ++y) {
        for (let x = 0; x < 12; ++x) {
            switch (mainmap[y][x]) {
                case 0:
                    gs_ctx.drawImage(dirtpathT, 0, 0, 500, 500, x*tileD, y*tileD, tileD, tileD);
                    break;
                case 1:
                    gs_ctx.drawImage(calmwaterT, 0, 0, 500, 500, x*tileD, y*tileD, tileD, tileD);
                    break;
                default:
                    gs_ctx.fillStyle = 'rgb(52,140,49)';
                    gs_ctx.fillRect(x*tileD, y*tileD, tileD, tileD);
            }
        }
    }
    //handle player sprite
    gs_ctx.drawImage(playerS, playerSdata[2]*500, 0, 500, 500, playerSdata[0], playerSdata[1], tileD*0.9, tileD*0.9);
    window.requestAnimationFrame(draw);
}

//keyboardstuff
function keyboardstuff(keyevent) {
    if(keyevent.key === "ArrowRight") {playerSdata[0] += 5; playerSdata[2] = 0}
    if(keyevent.key === "ArrowLeft") {playerSdata[0] -= 5; playerSdata[2] = 1}
    if(keyevent.key === "ArrowUp") {playerSdata[1] -= 5; playerSdata[2] = 2}
    if(keyevent.key === "ArrowDown") {playerSdata[1] += 5; playerSdata[2] = 3}
}

window.addEventListener("keydown", function(key){keyboardstuff(key)})